using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using System.Data;

namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///GUI dialog allowing user to specify the blood product they wish to select
		///</summary>

		#endregion


	public class DlgSelectBloodProduct : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.ListBox lstBloodProduct;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpProduct;
		private System.ComponentModel.IContainer components;
		private System.Data.DataTable _bloodProducts;

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// DlgSelectBloodProduct class constructor.
		/// Populates list with blood product collection.
		/// </summary>
		/// <param name="bloodProducts"></param>
		public DlgSelectBloodProduct(DataTable bloodProducts)
		{

			InitializeComponent();
			this._bloodProducts = bloodProducts;
			//
			vbecsLogo1.Title = "Select Blood Product";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.Common.DlgSelectBloodProduct());
			//
			RequiredFieldsLabel = false;
			//
			lstBloodProduct.Items.Clear();
			foreach(System.Data.DataRow dtRow in bloodProducts.Rows)
			{
				lstBloodProduct.Items.Add(dtRow[Common.VbecsTables.BloodProduct.ProductName].ToString());
			}

			lstBloodProduct.SelectedIndex = 0;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.btnOK = new System.Windows.Forms.Button();
			this.lstBloodProduct = new System.Windows.Forms.ListBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpProduct = new System.Windows.Forms.GroupBox();
			this.grpProduct.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(376, 30);
			this.vbecsLogo1.TabIndex = 2;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 204);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 3;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Enabled = false;
			this.btnOK.Location = new System.Drawing.Point(294, 189);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// lstBloodProduct
			// 
			this.lstBloodProduct.AccessibleDescription = "Select Blood Product";
			this.lstBloodProduct.AccessibleName = "Select Blood Product";
			this.lstBloodProduct.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstBloodProduct.ItemHeight = 14;
			this.lstBloodProduct.Location = new System.Drawing.Point(8, 16);
			this.lstBloodProduct.Name = "lstBloodProduct";
			this.lstBloodProduct.Size = new System.Drawing.Size(352, 130);
			this.lstBloodProduct.TabIndex = 0;
			this.lstBloodProduct.DoubleClick += new System.EventHandler(this.clstDivision_DoubleClick);
			this.lstBloodProduct.SelectedIndexChanged += new System.EventHandler(this.lstBloodProduct_SelectedIndexChanged);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// grpProduct
			// 
			this.grpProduct.AccessibleDescription = "Select Blood Product";
			this.grpProduct.AccessibleName = "Select Blood Product";
			this.grpProduct.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpProduct.Controls.Add(this.lstBloodProduct);
			this.grpProduct.Location = new System.Drawing.Point(4, 32);
			this.grpProduct.Name = "grpProduct";
			this.grpProduct.Size = new System.Drawing.Size(368, 152);
			this.grpProduct.TabIndex = 0;
			this.grpProduct.TabStop = false;
			this.grpProduct.Text = "Select Blood Product*";
			// 
			// DlgSelectBloodProduct
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(376, 220);
			this.ControlBox = false;
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpProduct);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(384, 244);
			this.Name = "DlgSelectBloodProduct";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "Select Blood Product";
			this.Controls.SetChildIndex(this.grpProduct, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpProduct.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// ListView DoubleClick event. Closes dialog with OK result.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void clstDivision_DoubleClick(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// OK button click event handler. Close dialog with OK result.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		

		private void lstBloodProduct_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.btnOK.Enabled = true;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		/// <summary>
		/// Gets blood product selected from list
		/// </summary>
		public BOL.BloodProduct BloodProduct
		{
			get
			{
				if (lstBloodProduct.SelectedItems.Count > 0)
				{
					DataTable dt = this._bloodProducts;
					string sTest = ((System.Guid) dt.Rows[lstBloodProduct.SelectedIndex][Common.VbecsTables.BloodProduct.BloodProductGuid]).ToString();
					return new BloodProduct((System.Guid) dt.Rows[lstBloodProduct.SelectedIndex][Common.VbecsTables.BloodProduct.BloodProductGuid]);
				}					
				
				return null;
			}
	
		}


	}
}

